#include <iostream>

using namespace std;

#define num int

void calculatePrefix(int p[], int n, int prefix[]) {
    int sum = 0;

    for (int i = 0; i < n; i++) {
        sum += p[i];

        prefix[i] = sum;
    }
}

void sort(int arr[][2], int ep, int sp = 0) {
    if (sp >= ep) return;

    int pivot = arr[ep - 1][0];

    int i = sp, j = sp;
    while (j < ep) {
        if (arr[j][0] < pivot) {
            int tmp = arr[j][0];
            arr[j][0] = arr[i][0];
            arr[i][0] = tmp;

            tmp = arr[j][1];
            arr[j][1] = arr[i][1];
            arr[i][1] = tmp;

            i++;
        }

        j++;
    }

    arr[ep - 1][0] = arr[i][0];
    arr[i][0] = pivot;

    int tmp = arr[ep - 1][1];
    arr[ep - 1][1] = arr[i][1];
    arr[i][1] = tmp;

    //cout << sp << ' ' << ep << ' ' << arr[0][0] << '\n';

    sort(arr, i, sp);
    sort(arr, ep, i + 1);
}

int binarySearch(int arr[][2], int r, int x) {
    int l = 0;
    r--;

    while (r >= l) {
        int mid = (r + l) / 2;

        if (arr[mid][0] == x) return mid;
        else if (arr[mid][0] > x) r = mid - 1;
        else l = mid + 1;
    }

    return -1;
}

int binaryIndex(int arr[][2], int r, int x) {
    int l = 0;
    r--;

    while (r >= l) {
        int mid = (r + l) / 2;

        if (arr[mid][1] == x) return mid;
        else if (arr[mid][1] > x) r = mid - 1;
        else l = mid + 1;
    }

    return -1;
}

int findLastSmallest(int arr[][2], int n, int x) {
    int l = 0;
    int r = n - 1;

    while (r >= l) {
        int mid = (r + l) / 2;

        if (arr[mid][0] == x && (mid == n - 1 || arr[mid + 1][0] > x)) return mid + 1;
        else if (arr[mid][0] == x) l = mid + 1;

        else if (arr[mid][0] < x && (mid == n - 1 || arr[mid + 1][0] > x)) return mid + 1;
        else if (arr[mid][0] < x) l = mid + 1;

        else if (arr[mid][0] > x && (mid == 0 || arr[mid - 1][0] < x)) return mid;
        else r = mid - 1;
    }

    return -1;
}

int correctSearch(int lowestValue[][2], int n, int currentLocation, int lookForIndex) {
    int i = currentLocation + 1;
    while (lowestValue[i][0] == lowestValue[currentLocation][0] && i < n) {
        if (lowestValue[i][1] == lookForIndex) return i;
        i++;
    }

    i = currentLocation - 1;
    while (lowestValue[i][0] == lowestValue[currentLocation][0] && i > 0) {
        if (lowestValue[i][1] == lookForIndex) return i;
        i--;
    }

    return -1;
}

void replaceValue(int lowest[0][2], int n, int oldIndex, int newValue, int newIndex) {
    //cout << "Inserting {" << newValue << ", " << newIndex << "} instead of " << oldIndex << '\n';
    oldIndex = binaryIndex(lowest, n, oldIndex);

    //cout << "Old index at index " << oldIndex << '\n';

    bool lookHigher = lowest[oldIndex][0] >= newValue;
    int newPosition = findLastSmallest(lowest, n, newValue);

    if (!lookHigher) newPosition--;

    //cout << "New index is " << newPosition << '\n';

    if (lookHigher) {
        for (int i = newPosition; i <= oldIndex; i++) {
            int tmpV = lowest[i][0];
            int tmpI = lowest[i][1];

            lowest[i][0] = newValue;
            lowest[i][1] = newIndex;

            newValue = tmpV;
            newIndex = tmpI;
        }
    }

    else {
        for (int i = newPosition; i >= oldIndex; i--) {
            int tmpV = lowest[i][0];
            int tmpI = lowest[i][1];

            lowest[i][0] = newValue;
            lowest[i][1] = newIndex;

            newValue = tmpV;
            newIndex = tmpI;
        }
    }
}

int main() {
    int n, k, x;
    cin >> n >> k >> x;

    x--;

    int p[n];
    for (int i = 0; i < n; i++) {
        cin >> p[i];
    }

    int prefix[n];
    calculatePrefix(p, n, prefix);

    //keep track of the x lowest prefix sums in the range
    int lowest[k][2];
    for (int i = 0; i < k; i++) {
            lowest[i][0] = prefix[i];
            lowest[i][1] = i;
    }

    sort(lowest, k);

    /*cout << "Prefix: ";
    for (int i = 0; i < n; i++) {
        cout << prefix[i] << ' ';
    }
    cout << '\n';*/

    int solution[n - k + 1];
    for (int i = 0; i < n - k + 1; i++) {
        solution[i] = (x + 1) * prefix[k - 1 + i];
        if (i > 0) solution[i] -= prefix[i - 1];

        for (int j = 0; j < x; j++) {
            solution[i] -= lowest[j][0];
        }

        /*if (true) {
            cout << i << " lowest: ";
            for (int j = 0; j < k; j++) {
                cout << "{" << lowest[j][0] << ", " << lowest[j][1] << "}, ";
            }
            cout << " result " << solution[i] << '\n';
        }*/

        replaceValue(lowest,
                     k,
                     i,
                     prefix[i + k],
                     i + k);

        cout << solution[i] << ' ';
    }
    cout << endl;

    // 1 -2 4 4 -5
    // 1 -1 3 7 2

    // 1 -1 3  lowest = {{-1, 1}, {1, 0}, {3, 2}} value =
    // -1 3 7  sorted = -1  3  7
    // 3 7 2   sorted =  2  3  7

    // 7  14 3

    return 0;
}